<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Question
 * 
 * @property int $id
 * @property int|null $subject_id
 * @property int|null $grade_id
 * @property int|null $level_id
 * @property int|null $goal_id
 * @property int|null $skill_id
 * @property int|null $question_type
 * @property string|null $question_text
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property string|null $correct_answer
 * 
 * @property Goal|null $goal
 * @property Grade|null $grade
 * @property Level|null $level
 * @property Skill|null $skill
 * @property Subject|null $subject
 * @property Collection|QuestionOption[] $question_options
 * @property Collection|UsersAnswer[] $users_answers
 *
 * @package App\Models
 */
class Question extends Model
{
	protected $table = 'questions';

	protected $casts = [
		'subject_id' => 'int',
		'grade_id' => 'int',
		'level_id' => 'int',
		'goal_id' => 'int',
		'skill_id' => 'int',
		'question_type' => 'int'
	];

	protected $fillable = [
		'subject_id',
		'grade_id',
		'level_id',
		'goal_id',
		'skill_id',
		'question_type',
		'question_text',
		'correct_answer'
	];

	public function goal()
	{
		return $this->belongsTo(Goal::class);
	}

	public function grade()
	{
		return $this->belongsTo(Grade::class);
	}

	public function level()
	{
		return $this->belongsTo(Level::class);
	}

	public function skill()
	{
		return $this->belongsTo(Skill::class);
	}

	public function subject()
	{
		return $this->belongsTo(Subject::class);
	}

	public function question_options()
	{
		return $this->hasMany(QuestionOption::class);
	}

	public function users_answers()
	{
		return $this->hasMany(UsersAnswer::class);
	}
}
