<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Template
 * 
 * @property int $id
 * @property string|null $name
 * @property string|null $description
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * @property int|null $grade_id
 * @property int|null $subject_id
 * 
 * @property Collection|TemplateSection[] $template_sections
 *
 * @package App\Models
 */
class Template extends Model
{
	protected $table = 'templates';

	protected $casts = [
		'grade_id' => 'int',
		'subject_id' => 'int'
	];

	protected $fillable = [
		'name',
		'description',
		'grade_id',
		'subject_id'
	];

	public function template_sections()
	{
		return $this->hasMany(TemplateSection::class);
	}
}
