<?php

/**
 * Created by Reliese Model.
 */

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TemplateSection
 * 
 * @property int $id
 * @property int|null $template_id
 * @property int|null $count_questions
 * @property int|null $level_id
 * @property int|null $goal_id
 * @property int|null $skill_id
 * @property string|null $description
 * @property string|null $title
 * @property Carbon|null $created_at
 * @property Carbon|null $updated_at
 * 
 * @property Template|null $template
 *
 * @package App\Models
 */
class TemplateSection extends Model
{
	protected $table = 'template_sections';

	protected $casts = [
		'template_id' => 'int',
		'count_questions' => 'int',
		'level_id' => 'int',
		'goal_id' => 'int',
		'skill_id' => 'int'
	];

	protected $fillable = [
		'template_id',
		'count_questions',
		'level_id',
		'goal_id',
		'skill_id',
		'description',
		'title'
	];

	public function template()
	{
		return $this->belongsTo(Template::class);
	}
}
